# Bash/Zsh History Configuration - README

This package contains optimized history configurations for Bash and Zsh.

## Files Included

1. **.bashrc_history** - Bash history configuration
   - Optimized history size (50K in memory, 100K on disk)
   - Timestamps enabled
   - Duplicate handling
   - Real-time sync across terminals

2. **.zshrc_history** - Zsh history configuration
   - Extended history with timestamps
   - Duplicate management
   - History sharing between sessions
   - Custom search bindings

3. **backup_history.sh** - Automated history backup
   - Creates timestamped backups
   - Compresses old backups
   - Automatic cleanup (30 days)

4. **history_stats.sh** - Command usage analysis
   - Top 20 most used commands
   - Command category breakdown
   - History statistics

## Installation

### For Bash:

```bash
# Backup existing config
cp ~/.bashrc ~/.bashrc.backup

# Append history configuration
cat .bashrc_history >> ~/.bashrc

# Reload configuration
source ~/.bashrc
```

### For Zsh:

```bash
# Backup existing config
cp ~/.zshrc ~/.zshrc.backup

# Append history configuration
cat .zshrc_history >> ~/.zshrc

# Reload configuration
source ~/.zshrc
```

### Setup Automated Backup:

```bash
# Make backup script executable
chmod +x backup_history.sh

# Add to crontab (daily backup at midnight)
(crontab -l 2>/dev/null; echo "0 0 * * * /path/to/backup_history.sh") | crontab -
```

## Usage

### View History with Timestamps:
```bash
history
```

### Search History:
```bash
# Interactive search
Ctrl+R

# Grep search
history | grep "docker"
```

### Analyze Usage:
```bash
./history_stats.sh
```

## Configuration Options

### Increase History Size:
Edit HISTSIZE and HISTFILESIZE values in the config files.

### Ignore More Commands:
Add to HISTIGNORE variable:
```bash
export HISTIGNORE="ls:cd:pwd:exit:your_command"
```

### Disable Timestamps:
Comment out or remove:
```bash
# export HISTTIMEFORMAT="%F %T "
```

## Security Tips

1. **Ignore sensitive commands** - Start with space:
   ```bash
    mysql -u root -p secret_password
   ```

2. **Clear specific entries**:
   ```bash
   history -d 1234
   ```

3. **Encrypt history file**:
   ```bash
   gpg -c ~/.bash_history
   ```

## Learn More

Visit: https://yourdomain.com/docs/bash-zsh/history-command/
