#!/bin/bash
# file_processor.sh - Process files in a directory

# Check if directory argument provided
if [ $# -eq 0 ]; then
    echo "Usage: $0 <directory>"
    exit 1
fi

DIR="$1"

if [ ! -d "$DIR" ]; then
    echo "Error: $DIR is not a directory"
    exit 1
fi

echo "Processing files in: $DIR"
echo "================================"

# Process all .txt files
for file in "$DIR"/*.txt
do
    # Check if file exists (handles case where no .txt files exist)
    [ -e "$file" ] || continue
    
    echo "Processing: $(basename "$file")"
    
    # Count lines
    lines=$(wc -l < "$file")
    echo "  Lines: $lines"
    
    # Count words
    words=$(wc -w < "$file")
    echo "  Words: $words"
    
    echo ""
done

echo "Processing complete!"
